function Figure1S3B()
% This script plots data from Figure 1 - figure supplement 3B for both
% replicates.

%==========================================================================
% Determine labeling ratio from replicate 1:
load('488Fab_640Fab_rep1.mat');
Q = median(X./Y);
load('488Fab_640SrtA_rep1.mat');
Y = Q*Y;
[N,q] = hist3([log10(X)',log10(Y)'],'Nbins',[35 35]);
N = N./max(max(N));
disp(['Cy5:AF488 ratio (rep.1): ',num2str(median(Y./X))])

v0 = [0.2:0.2:1];
figure; 
[M,junk] = contour(q{1},q{2},N'); close
lowest = 1;
while lowest == 1;
  lev = M(1,1);
  v = M(2,1); xy = M(:,2:(1+v))';
  in = inpolygon(log10(X),log10(Y),xy(:,1),xy(:,2));
  X(in) = []; Y(in) = [];
  M(:,1:(1+v)) = [];
  next_lev = M(1,1);
  if(next_lev == lev); lowest = 1;
  else lowest = 0; end
end
figure;
plot(log10(X),log10(Y),'.','Color',[0.5 0.5 0.5]); xlim([0 7]); ylim([0 7]); hold on;
contour(q{1},q{2},N'); colormap('hot'); view(2); xlim([0 7]); ylim([0 7]); 
plot([0 7],[0 7],':k'); axis square; drawnow;
title('Labeling ratio, replicate 1');
xlabel('log10 D25(AF488) intensity');
ylabel('log10 SrtA(Cy5) intensity (calibrated)');
%==========================================================================

%==========================================================================
% Determine labeling ratio from replicate 2:
load('488Fab_640Fab_rep2.mat');
Q = median(X./Y);
load('488Fab_640SrtA_rep2.mat');
Y = Q*Y;
[N,q] = hist3([log10(X)',log10(Y)'],'Nbins',[35 35]);
N = N./max(max(N));
disp(['Cy5:AF488 ratio (rep.2): ',num2str(median(Y./X))])
 
v0 = [0.2:0.2:1];
figure; 
[M,junk] = contour(q{1},q{2},N'); close
lowest = 1;
while lowest == 1;
  lev = M(1,1);
  v = M(2,1); xy = M(:,2:(1+v))';
  in = inpolygon(log10(X),log10(Y),xy(:,1),xy(:,2));
  X(in) = []; Y(in) = [];
  M(:,1:(1+v)) = [];
  next_lev = M(1,1);
  if(next_lev == lev); lowest = 1;
  else lowest = 0; end
end
figure;
plot(log10(X),log10(Y),'.','Color',[0.5 0.5 0.5]); xlim([0 7]); ylim([0 7]); hold on;
contour(q{1},q{2},N'); colormap('hot'); view(2); xlim([0 7]); ylim([0 7]); 
plot([0 7],[0 7],':k'); axis square; drawnow;
title('Labeling ratio, replicate 2');
xlabel('log10 D25(AF488) intensity');
ylabel('log10 SrtA(Cy5) intensity (calibrated)');
%==========================================================================